#include <bits/stdc++.h>
#include "testlib.h"

using namespace std;

bool same_brick(int x1, int y1, int x2, int y2)
{
    return x1 == x2 && ((y1 / 2 == y2 / 2) == (x1 % 2 == 0));
}

int main(int argc, char *argv[]) {
    registerTestlibCmd(argc, argv);

    int n = inf.readInt();
    int m = inf.readInt();

    set<char> used;
    vector<string> bricks = ouf.readLines(n, "[1-9]{2,20}");
    if (bricks.size() != n)
        quitf(_wa, "The answer must contain exactly %d rows (n = %d)", n);
    for (int i = 0; i < n; ++i)
    {
        if (bricks[i].size() != m)
            quitf(_wa, "All rows must be exactly %d characters long (m = %d)", m);
    }

    reverse(bricks.begin(), bricks.end());

    for (int x = 0; x < n; ++x)
        for (int y = 0; y < m; ++y)
        {
            used.insert(bricks[x][y]);
            vector <int> neigh_x = {x - 1, x + 1, x, x};
            vector <int> neigh_y = {y, y, y - 1, y + 1};
            for (int i = 0; i < 4; ++i)
            {
                int x1 = neigh_x[i];
                int y1 = neigh_y[i];
                if (0 <= x1 && x1 < n && 0 <= y1 && y1 < m)
                {
                    if (same_brick(x, y, x1, y1))
                    {
                        if (bricks[x][y] != bricks[x1][y1])
                            quitf(_wa, "Two cells have different colors, but they belong to the same brick. Row %d, columns %d and %d", n - x, 1 + y, 1 + y1);
                    }
                    else
                    {
                        if (bricks[x][y] == bricks[x1][y1])
                            quitf(_wa, "Two adjacent cells have the same color, but they belong to different bricks (row %d, column %d and row %d, column %d)", n - x, 1 + y, n - x1, 1 + y1);
                    }
                }
            }
        }
    int used_colors = used.size();
    if (n == 1 && m == 2 && used_colors == 1 ||
        n == 1 && m > 2 && used_colors == 2 ||
        n > 1 && used_colors == 3)
        quitf(_ok, "Correct solution");
    else
        quitf(_wa, "Not the minimal number of colors: you used %d different colors", used_colors);
}

