#!/usr/bin/python3
# -*- coding: utf-8 -*-

import json
import os
import sys

# Определяем тип тестирующей системы
# В отладочных целях можно заменить эти переменные на константы True/False
POLYGON = ("polygon" in os.environ.get("APPDATA", "0").lower()) or (
        "codeforces" in os.environ.get("APPDATA", "0").lower())
EJUDGE = "EJUDGE" in os.environ
SILVER = "SILVERTESTS_VERSION" in os.environ
SIRIUS = not (POLYGON or EJUDGE or SILVER)

# Коды возврата для передачи в функцию quit
OK = 0
WA = 1
PT = 1
PE = 2
CF = 3


# Класс для работы с ответом участника в тестирующей системе Сириуса
class AnswerSMT():
    def __init__(self, userAnswer=None, score=0, maxScore=100):
        '''считывание ответа'''
        if userAnswer is None:
            self.userAnswer = json.loads("".join(sys.stdin.readlines()))['solution']
        else:
            self.userAnswer = json.loads(userAnswer)

        '''считаем количество элементов ввода и делаем список ответов по элементам ввода'''
        if type(self.userAnswer) is dict:
            self.elements = 1
            if type(self.userAnswer['solution']) is dict:
                self.userAnswer = [[self.userAnswer['solution']['message']]]
            elif type(self.userAnswer['solution']) is int:
                self.userAnswer = [[self.userAnswer['solution']]]
            else:
                self.userAnswer = [self.userAnswer['solution']]
        else:
            self.elements = len(self.userAnswer)
            a = []
            for i in range(0, self.elements):
                if type(self.userAnswer[i]['solution']) is int:
                    a.append([self.userAnswer[i]['solution']])
                else:
                    a.append(self.userAnswer[i]['solution'])
            self.userAnswer = a

        '''считаем, сколько полей ввода для каждого элемента ввода'''
        self.userAnswerLength = []
        for i in range(0, self.elements):
            if type(self.userAnswer[i]) is list:
                self.userAnswerLength.append(len(self.userAnswer[i]))
            elif self.userAnswer[i] != '':
                self.userAnswerLength.append(1)
            else:
                self.userAnswerLength.append(0)

        self.comment = ''
        self.score = score
        self.maxScore = maxScore
        self.verdict = 'WA'

    def answer(self, element=0, field=0):
        '''Возвращает ответ участника из элмента ввода с номером element.
        Если в элементе ввода несколько полей ввода, то можно указать номер поля ввода'''
        if element >= self.elements:
            return None
        else:
            a = self.userAnswer[element]

        if a is None:
            return None
        if field >= len(a):
            return None
        else:
            return None if a[field] is None else str(a[field])

    def fields_in_element(self, element=0):
        '''Возвращает информацию о количестве полей ввода в элементе ввода'''
        if len(self.userAnswerLength) <= element:
            return 0
        else:
            return self.userAnswerLength[element]

    def print_answer(self):
        '''посмотреть всё содержимое для отладки'''
        print("user answer:")
        print(self.userAnswer)
        print("number of elements")
        print(self.elements)
        print('length of elements')
        print(self.userAnswerLength)

    def quit(self, comment=None, score=None, maxScore=None, verdict=None):
        if not comment is None:
            self.comment = comment

        if not score is None:
            self.score = score

        if not maxScore is None:
            self.maxScore = maxScore

        if not verdict is None:
            self.verdict = verdict

        print(json.dumps({"maxScore": self.maxScore,
                          "score": self.score,
                          "comment": self.comment,
                          "verdict": self.verdict}))
        sys.exit(0)


def quit(status, log="", score=0):
    if SIRIUS:
        if status in [OK, WA] and 0 < score < 100:
            status = PT
        comment = log.replace("\n", "\n\n")  # Дублируем концы строк для разметки
        sirius_ans_obj.quit(verdict=status, comment=comment, score=score)
        return

    if POLYGON:  # Нужно в Polygon, т.к. там Windows
        sys.stdout.reconfigure(encoding='utf-8')
        sys.stderr.reconfigure(encoding='utf-8')

    # Выводим набранные баллы
    if status in [OK, WA]:
        if POLYGON:
            sys.stderr.write("points " + str(score) + "\n")
            status = 7  # Код возврата полигона, сообщающий о наличии баллов
        elif EJUDGE or SILVER:
            sys.stdout.write(str(score) + "\n")

    # Выводим протокол проверки
    sys.stderr.write(log)

    # Возвращаем код возврата
    sys.exit(status)


def init():
    global OK, WA, PE, CF, PT
    global sirius_ans_obj
    if SIRIUS:
        PE = "PE"
        WA = "WA"
        OK = "OK"
        CF = "CF"
        PT = "PT"
        # При создании объекта можно в конструктор в целях отладки передать строку с JSON, тогда ответ будет считан с этого JSON, иначе из stdin
        sirius_ans_obj = AnswerSMT()


init()


########################################################################################
# Код дальше можно править
#
# Код этой функции надо исправить так, чтобы она возвращала ответ, полученный из JSON в Сириусе
# или полученный из файла в тестирующих системах Ejudge или Polygon
# Формат возвращаемого значения - произвольный, например, одна строка или список строк
# При необходимости можно прямо в этом коде делать quit(PE, ...)
#
# В тестирующей системе Сириуса:
# Задание состоит из "элементов" (разделов"), внутри раздела могут быть поля ввода.
# Например, задание вида "Дайте ответ для а) N = 10 б) N = 20, в) N = 30" - это три раздела, они будут визуально отделены.
# А задание вида "Напишите в ответе номера объектов, которые вы выбрали, добавляя поля по необходимости" - это один раздел с несколькими полями ввода
# При считывании данных из тестирующей системы Сириуса нужно использовать объект sirius_ans_obj
# со следующим интерфейсом.
# sirius_ans_obj.elements - количество "элементов" в ответе.
# sirius_ans_obj.fields_in_element(element=0) - возвращает количество полей ввода в элементе номер element, нумерация с нуля
# sirius_ans_obj.answer(element=0, field=0) - возвращает значение поля ввода номер field из элемента номер element, нумерация с нуля
########################################################################################

def get_answer():
    ans = []
    if SIRIUS:
        for i in range(sirius_ans_obj.elements):
            elem = sirius_ans_obj.answer(element=i)
            # Если ответ в Сириусе состоит из нескольких полей, то там может оказаться None. Необходимо это учесть.
            if elem is None:
                elem = ""
            elem = elem.strip()
            if elem:
                ans.append(elem)
    elif POLYGON or SILVER:
        if POLYGON:
            fin = open(sys.argv[2], "r", encoding="utf8")
        elif SILVER:
            fin = sys.stdin
        data = fin.read()
        data = data.replace(",", " ").replace(":", " ").replace(";", " ")
        while "  " in data:
            data = data.replace("  ", " ")
        ans = data.split()
    return ans


def has_digit_eight(num_str):
    return '8' in num_str


def sum_digits_equals_14(num_str):
    return sum(int(digit) for digit in num_str) == 14


def adjacent_digits_different(num_str):
    for i in range(len(num_str) - 1):
        if num_str[i] == num_str[i + 1]:
            return False
    return True


def has_two_equal_digit_pairs(num_str):
    digit_counts = {}
    for digit in num_str:
        if digit not in digit_counts:
            digit_counts[digit] = 0
        digit_counts[digit] += 1

    pairs = 0
    for digit, count in digit_counts.items():
        pairs += count // 2

    return pairs == 2


def check_criteria(num_str):
    criteria = {
        "has_8": has_digit_eight(num_str),
        "sum_14": sum_digits_equals_14(num_str),
        "adj_diff": adjacent_digits_different(num_str),
        "two_pairs": has_two_equal_digit_pairs(num_str)
    }
    return criteria


def count_criteria(num_str):
    criteria_dict = check_criteria(num_str)
    return sum(criteria_dict.values())


def get_criteria_set(num_str):
    criteria = check_criteria(num_str)
    return tuple(name for name, value in criteria.items() if value)


ans = get_answer()

i = 0
while i < len(ans):
    ans[i] = ans[i].strip()
    if not ans[i]:
        ans.pop(i)
        continue
    if not ans[i].isdigit():
        quit(PE, f"Значение {i + 1} ответа содержит не цифру.")
    i += 1

if len(ans) != 5:
    quit(PE, "В ответе должно быть ровно пять чисел")
ans = [None] + ans

correct1 = "63"

correct2 = "55"
partial2 = {"61": 11, "62": 5}

correct3 = "67"
partial3 = {"64": 5, "65": 11}

correct4 = "33"
partial4 = {"37" : 11, "41" : 10, "43" : 9, "45" : 8, "47" : 7, "51" : 6, "55" : 5, "57" : 4, "59" : 3, "60" : 2, "61" : 1, "62" : 1}

correct5 = "92"
partial5 = {"64" : 1, "65" : 1, "67" : 2, "69" : 2, "71" : 3, "72" : 3, "75" : 4, "77" : 5, "79" : 6, "81" : 7, "84" : 8, "85" : 9, "87" : 10, "89" : 11}

result_log = ""
score = 0

if ans[1] == correct1:
    result_log += "Ответ на первый вопрос верный.\n"
    score += 12
else:
    result_log += f"Ответ на первый вопрос неправильный. Ваш ответ: {ans[1]}, верный ответ: {correct1}.\n"

if ans[2] == correct2:
    result_log += "Ответ на второй вопрос верный.\n"
    score += 22
elif ans[2] in partial2:
    result_log += f"В ответе на второй вопрос найдено не минимальное число. Ваш ответ: {ans[2]}, верный ответ: {correct2}.\n"
    score += partial2[ans[2]]
else:
    result_log += f"Ответ на второй вопрос неправильный, такое число не могло получиться при обмене двух соседних команд. Ваш ответ: {ans[2]}, верный ответ: {correct2}.\n"
   
if ans[3] == correct3:
    result_log += "Ответ на третий вопрос верный.\n"
    score += 22
elif ans[3] in partial3:
    result_log += f"В ответе на третий вопрос найдено не максимальное число. Ваш ответ: {ans[3]}, верный ответ: {correct3}.\n"
    score += partial3[ans[3]]
else:
    result_log += f"Ответ на третий вопрос неправильный, такое число не могло получиться при обмене двух соседних команд. Ваш ответ: {ans[3]}, верный ответ: {correct3}.\n"

if ans[4] == correct4:
    result_log += "Ответ на четвёртый вопрос верный.\n"
    score += 22
elif ans[4] in partial4:
    result_log += f"В ответе на четвёртый вопрос найдено не минимальное число. Ваш ответ: {ans[4]}, верный ответ: {correct4}.\n"
    score += partial4[ans[4]]
else:
    result_log += f"Ответ на четвёртый вопрос неправильный, такое число не могло получиться при обмене никаких двух команд. Ваш ответ: {ans[4]}, верный ответ: {correct4}.\n"
   
if ans[5] == correct5:
    result_log += "Ответ на пятый вопрос верный.\n"
    score += 22
elif ans[5] in partial5:
    result_log += f"В ответе на пятый вопрос найдено не максимальное число. Ваш ответ: {ans[5]}, верный ответ: {correct5}.\n"
    score += partial5[ans[5]]
else:
    result_log += f"Ответ на пятый вопрос неправильный, такое число не могло получиться при обмене двух соседних команд. Ваш ответ: {ans[5]}, верный ответ: {correct5}.\n"

result_log += f"\nИтоговый балл: {score} из 100"
quit(OK if score == 100 else WA, result_log, score=score)
