#!/usr/bin/python3
# -*- coding: utf-8 -*-

import sys
import os
import re
import json

# Определяем тип тестирующей системы
# В отладочных целях можно заменить эти переменные на константы True/False
POLYGON = ("polygon" in os.environ.get("APPDATA", "0").lower()) or ("codeforces" in os.environ.get("APPDATA", "0").lower())
EJUDGE = "EJUDGE" in os.environ
SILVER = "SILVERTESTS_VERSION" in os.environ
SIRIUS = not(POLYGON or EJUDGE or SILVER)

# Коды возврата для передачи в функцию quit
OK = 0
WA = 1
PT = 1
PE = 2
CF = 3

# Класс для работы с ответом участника в тестирующей системе Сириуса
class AnswerSMT():
    def __init__(self, userAnswer=None, score=0, maxScore=100):
        '''считывание ответа'''
        if userAnswer is None:
            self.userAnswer = json.loads("".join(sys.stdin.readlines()))['solution']
        else:
            self.userAnswer = json.loads(userAnswer)
        
        
        '''считаем количество элементов ввода и делаем список ответов по элементам ввода'''
        if type(self.userAnswer) is dict:
            self.elements = 1
            if type(self.userAnswer['solution']) is dict:
                self.userAnswer = [[self.userAnswer['solution']['message']]]
            elif type(self.userAnswer['solution']) is int:
                self.userAnswer = [[self.userAnswer['solution']]]
            else:
                self.userAnswer = [self.userAnswer['solution']]
        else: 
            self.elements = len(self.userAnswer)
            a = []
            for i in range(0, self.elements):
                if type(self.userAnswer[i]['solution']) is int:
                    a.append([self.userAnswer[i]['solution']])
                else:
                    a.append(self.userAnswer[i]['solution'])
            self.userAnswer = a
        
        '''считаем, сколько полей ввода для каждого элемента ввода'''
        self.userAnswerLength = []
        for i in range(0, self.elements):
            if type(self.userAnswer[i]) is list:
                self.userAnswerLength.append(len(self.userAnswer[i]))
            elif self.userAnswer[i] != '':
                self.userAnswerLength.append(1)
            else:
                self.userAnswerLength.append(0)
        
        self.comment = ''
        self.score = score
        self.maxScore = maxScore
        self.verdict = 'WA'
          
    def answer(self, element=0, field=0):
        '''Возвращает ответ участника из элмента ввода с номером element.
        Если в элементе ввода несколько полей ввода, то можно указать номер поля ввода'''
        if element >= self.elements:
            return None
        else:
            a = self.userAnswer[element]
        
        if a is None:
            return None
        if field >= len(a):
            return None
        else: 
            return None if a[field] is None else str(a[field])
    
    def fields_in_element(self, element=0):
        '''Возвращает информацию о количестве полей ввода в элементе ввода'''
        if len(self.userAnswerLength) <= element: 
            return 0
        else:
            return self.userAnswerLength[element]
    
    def print_answer(self):
        '''посмотреть всё содержимое для отладки'''
        print("user answer:")
        print(self.userAnswer)
        print("number of elements")
        print(self.elements)
        print('length of elements')
        print(self.userAnswerLength)
    
    def quit(self, comment=None, score=None, maxScore=None, verdict=None):
        if not comment is None:
            self.comment = comment
        
        if not score is None:
            self.score = score
        
        if not maxScore is None:
            self.maxScore = maxScore
            
        if not verdict is None:
            self.verdict = verdict
            
        print(json.dumps({"maxScore":self.maxScore,
                          "score":self.score,
                          "comment":self.comment,
                          "verdict":self.verdict}))
        sys.exit(0)


def quit(status, log="", score=0):
    if SIRIUS:
        if status in [OK, WA] and 0 < score < 100:
            status = PT
        comment = log.replace("\n", "\n\n") # Дублируем концы строк для разметки
        sirius_ans_obj.quit(verdict=status, comment=comment, score=score)
        return
    
    if POLYGON: # Нужно в Polygon, т.к. там Windows
        sys.stdout.reconfigure(encoding='utf-8')
        sys.stderr.reconfigure(encoding='utf-8')

    # Выводим набранные баллы
    if status in [OK, WA]:
        if POLYGON:
            sys.stderr.write("points " + str(score) + "\n")
            status = 7 # Код возврата полигона, сообщающий о наличии баллов
        elif EJUDGE or SILVER:
            sys.stdout.write(str(score) + "\n")
    
    # Выводим протокол проверки
    sys.stderr.write(log)
    
    # Возвращаем код возврата
    sys.exit(status)


def init():
    global OK, WA, PE, CF, PT
    global sirius_ans_obj
    if SIRIUS:
        PE = "PE"
        WA = "WA"
        OK = "OK"
        СF = "CF"
        PT = "PT"
        # При создании объекта можно в конструктор в целях отладки передать строку с JSON, тогда ответ будет считан с этого JSON, иначе из stdin
        sirius_ans_obj = AnswerSMT()


init()

########################################################################################
# Код дальше можно править
# 
# Код этой функции надо исправить так, чтобы она возвращала ответ, полученный из JSON в Сириусе
# или полученный из файла в тестирующих системах Ejudge или Polygon
# Формат возвращаемого значения - произвольный, например, одна строка или список строк
# При необходимости можно прямо в этом коде делать quit(PE, ...)
#
# В тестирующей системе Сириуса:
# Задание состоит из "элементов" (разделов"), внутри раздела могут быть поля ввода.
# Например, задание вида "Дайте ответ для а) N = 10 б) N = 20, в) N = 30" - это три раздела, они будут визуально отделены.
# А задание вида "Напишите в ответе номера объектов, которые вы выбрали, добавляя поля по необходимости" - это один раздел с несколькими полями ввода
# При считывании данных из тестирующей системы Сириуса нужно использовать объект sirius_ans_obj
# со следующим интерфейсом.
# sirius_ans_obj.elements - количество "элементов" в ответе.
# sirius_ans_obj.fields_in_element(element=0) - возвращает количество полей ввода в элементе номер element, нумерация с нуля
# sirius_ans_obj.answer(element=0, field=0) - возвращает значение поля ввода номер field из элемента номер element, нумерация с нуля
########################################################################################

def get_answer():
    ans = []
    if SIRIUS:
        for i in range(sirius_ans_obj.elements):
            elem = sirius_ans_obj.answer(element=i)
            # Если ответ в Сириусе состоит из нескольких полей, то там может оказаться None. Необходимо это учесть.
            if elem is None:
                elem = ""
            elem = elem.strip()
            if elem:
                ans.append(elem)
    elif POLYGON or SILVER:
        if POLYGON:
            fin = open(sys.argv[2], "r", encoding="utf8")
        elif SILVER:
            fin = sys.stdin
        for elem in fin:
            elem = elem.strip()
            if elem:
                ans.append(elem.strip())
    return ans


# От функции get_answer ожидается список из трёх строк, например, ["АМП", "ДРВ", "ТИС"]

ans = get_answer()

if len(ans) != 3:
    quit(PE, "В ответе должны быть ровно 3 строки")

GIRLS = "АДТ"
SUBJS = "МРИ"
DAYS = "ПВС"

for i in range(len(ans)):
    ans[i] = ans[i].strip().upper().replace(" ", "").replace(",", "").replace(";", "").replace("-", "").replace(".", "")
    # Меняем английские буквы на русские
    ans[i] = ans[i].replace("A", "А")
    ans[i] = ans[i].replace("M", "М")
    ans[i] = ans[i].replace("P", "Р")
    ans[i] = ans[i].replace("T", "Т")
    ans[i] = ans[i].replace("C", "С")
    ans[i] = ans[i].replace("B", "В")
    if len(ans[i]) != 3:
        quit(PE, f"Строка {i+1} ответа неверной длины, в каждой строке должно быть 3 буквы")
    if ans[i][0] not in GIRLS:
        quit(PE, f"В строке {i+1} ответа первый символ \xAB{ans[i][0]}\xBB неверный, должен быть один из символов {', '.join(GIRLS)}.")
    if ans[i][1] not in SUBJS:
        quit(PE, f"В строке {i+1} ответа второй символ \xAB{ans[i][1]}\xBB неверный, должен быть один из символов {', '.join(SUBJS)}.")
    if ans[i][2] not in DAYS:
        quit(PE, f"В строке {i+1} ответа третий символ \xAB{ans[i][2]}\xBB неверный, должен быть один из символов {', '.join(DAYS)}.")

s = "".join(ans)

for c in s:
    if s.count(c) > 1:
        quit(PE, f"В вашем ответе буква \xAB{c}\xBB встречается больше одного раза. Каждая из букв А, Д, Т, М, Р, И, П, В, С должна быть использована ровно один раз.")


def check(a):  # Возвращает количество выполненных условий
    for i in range(len(a)):
        if a[i][0] == "А":
            idx_A = i
        if a[i][0] == "Д":
            idx_D = i
        if a[i][0] == "Т":
            idx_T = i
        if a[i][1] == "И":
            idx_I = i
        if a[i][1] == "Р":
            idx_R = i
        if a[i][1] == "М":
            idx_M = i
    
    cnt = 0
    if a[idx_A][2] != "П":
        cnt += 1
    if DAYS.index(a[idx_I][2]) < DAYS.index(a[idx_R][2]):
        cnt += 1
    if a[idx_T][2] == "В":
        cnt += 1
    if a[idx_D][1] != "М":
        cnt += 1
    if a[idx_M][2] != "С":
        cnt += 1
    return cnt

cnt = check(ans)
if cnt == 5:
    quit(OK, "Это правильный ответ", score=100)
elif cnt == 4:
    quit(WA, "Это неправильный ответ, для вашего ответа выполнены только 4 условия из 5", score=40)
elif cnt == 3:
    quit(WA, "Это неправильный ответ, для вашего ответа выполнены только 3 условия из 5", score=10)
else:
    quit(WA, "Это неправильный ответ", score=0)
