#include "testlib.h"
#include <algorithm>
using namespace std;

int main(int argc, char *argv[]) {
   registerTestlibCmd(argc, argv);
   int a = inf.readInt(), b = inf.readInt();
   int minsteps = max(a, b) * 2 - 1;
   if ((a + b) % 2 == 0)
      minsteps++;

   int x = ouf.readInt(), y = ouf.readInt();
   if (abs(x) + abs(y) != 1)
      quitf(_wa, "Incorrect move from point (0, 0) to point (%d, %d)", x, y);
   char dir = (x == 0 ? 'y' : 'x'); 
   int steps = 1;   

   while (!ouf.seekEof()) {
      int xnext = ouf.readInt(), ynext = ouf.readInt();
      steps++;
      if (abs(x - xnext) + abs(y - ynext) != 1)
         quitf(_wa, "Incorrect move from point (%d, %d) to point (%d, %d)", x, y, xnext, ynext);
      dir = (dir == 'x' ? 'y' : 'x');
      if ((dir == 'x' && xnext == x) || (dir == 'y' && ynext == y))
         quitf(_wa, "Violation of the zigzag condition when moving from point (%d, %d) to point (%d, %d)", x, y, xnext, ynext);
      x = xnext;
      y = ynext;
   }
  
   if (x != a || y != b)
      quitf(_wa, "The final point (%d %d) differs from the required point (%d %d)", x, y, a, b);
   
   if (steps > minsteps)
      quitf(_wa, "The number of steps is not minimal: %d steps in output, but the minimum is %d", steps, minsteps);

   if (steps < minsteps)
      quitf(_fail, "Strange, better than jury");

   quitf(_ok, "Accepted");
}
