#!/usr/bin/python3
# -*- coding: utf-8 -*-

import json
import os
import sys

# Определяем тип тестирующей системы
# В отладочных целях можно заменить эти переменные на константы True/False
POLYGON = ("polygon" in os.environ.get("APPDATA", "0").lower()) or (
        "codeforces" in os.environ.get("APPDATA", "0").lower())
EJUDGE = "EJUDGE" in os.environ
SILVER = "SILVERTESTS_VERSION" in os.environ
SIRIUS = not (POLYGON or EJUDGE or SILVER)

# Коды возврата для передачи в функцию quit
OK = 0
WA = 1
PT = 1
PE = 2
CF = 3


# Класс для работы с ответом участника в тестирующей системе Сириуса
class AnswerSMT():
    def __init__(self, userAnswer=None, score=0, maxScore=100):
        '''считывание ответа'''
        if userAnswer is None:
            self.userAnswer = json.loads("".join(sys.stdin.readlines()))['solution']
        else:
            self.userAnswer = json.loads(userAnswer)

        '''считаем количество элементов ввода и делаем список ответов по элементам ввода'''
        if type(self.userAnswer) is dict:
            self.elements = 1
            if type(self.userAnswer['solution']) is dict:
                self.userAnswer = [[self.userAnswer['solution']['message']]]
            elif type(self.userAnswer['solution']) is int:
                self.userAnswer = [[self.userAnswer['solution']]]
            else:
                self.userAnswer = [self.userAnswer['solution']]
        else:
            self.elements = len(self.userAnswer)
            a = []
            for i in range(0, self.elements):
                if type(self.userAnswer[i]['solution']) is int:
                    a.append([self.userAnswer[i]['solution']])
                else:
                    a.append(self.userAnswer[i]['solution'])
            self.userAnswer = a

        '''считаем, сколько полей ввода для каждого элемента ввода'''
        self.userAnswerLength = []
        for i in range(0, self.elements):
            if type(self.userAnswer[i]) is list:
                self.userAnswerLength.append(len(self.userAnswer[i]))
            elif self.userAnswer[i] != '':
                self.userAnswerLength.append(1)
            else:
                self.userAnswerLength.append(0)

        self.comment = ''
        self.score = score
        self.maxScore = maxScore
        self.verdict = 'WA'

    def answer(self, element=0, field=0):
        '''Возвращает ответ участника из элмента ввода с номером element.
        Если в элементе ввода несколько полей ввода, то можно указать номер поля ввода'''
        if element >= self.elements:
            return None
        else:
            a = self.userAnswer[element]

        if a is None:
            return None
        if field >= len(a):
            return None
        else:
            return None if a[field] is None else str(a[field])

    def fields_in_element(self, element=0):
        '''Возвращает информацию о количестве полей ввода в элементе ввода'''
        if len(self.userAnswerLength) <= element:
            return 0
        else:
            return self.userAnswerLength[element]

    def print_answer(self):
        '''посмотреть всё содержимое для отладки'''
        print("user answer:")
        print(self.userAnswer)
        print("number of elements")
        print(self.elements)
        print('length of elements')
        print(self.userAnswerLength)

    def quit(self, comment=None, score=None, maxScore=None, verdict=None):
        if not comment is None:
            self.comment = comment

        if not score is None:
            self.score = score

        if not maxScore is None:
            self.maxScore = maxScore

        if not verdict is None:
            self.verdict = verdict

        print(json.dumps({"maxScore": self.maxScore,
                          "score": self.score,
                          "comment": self.comment,
                          "verdict": self.verdict}))
        sys.exit(0)


def quit(status, log="", score=0):
    if SIRIUS:
        if status in [OK, WA] and 0 < score < 100:
            status = PT
        comment = log.replace("\n", "\n\n")  # Дублируем концы строк для разметки
        sirius_ans_obj.quit(verdict=status, comment=comment, score=score)
        return

    if POLYGON:  # Нужно в Polygon, т.к. там Windows
        sys.stdout.reconfigure(encoding='utf-8')
        sys.stderr.reconfigure(encoding='utf-8')

    # Выводим набранные баллы
    if status in [OK, WA]:
        if POLYGON:
            sys.stderr.write("points " + str(score) + "\n")
            status = 7  # Код возврата полигона, сообщающий о наличии баллов
        elif EJUDGE or SILVER:
            sys.stdout.write(str(score) + "\n")

    # Выводим протокол проверки
    sys.stderr.write(log)

    # Возвращаем код возврата
    sys.exit(status)


def init():
    global OK, WA, PE, CF, PT
    global sirius_ans_obj
    if SIRIUS:
        PE = "PE"
        WA = "WA"
        OK = "OK"
        CF = "CF"
        PT = "PT"
        # При создании объекта можно в конструктор в целях отладки передать строку с JSON, тогда ответ будет считан с этого JSON, иначе из stdin
        sirius_ans_obj = AnswerSMT()


init()


########################################################################################
# Код дальше можно править
#
# Код этой функции надо исправить так, чтобы она возвращала ответ, полученный из JSON в Сириусе
# или полученный из файла в тестирующих системах Ejudge или Polygon
# Формат возвращаемого значения - произвольный, например, одна строка или список строк
# При необходимости можно прямо в этом коде делать quit(PE, ...)
#
# В тестирующей системе Сириуса:
# Задание состоит из "элементов" (разделов"), внутри раздела могут быть поля ввода.
# Например, задание вида "Дайте ответ для а) N = 10 б) N = 20, в) N = 30" - это три раздела, они будут визуально отделены.
# А задание вида "Напишите в ответе номера объектов, которые вы выбрали, добавляя поля по необходимости" - это один раздел с несколькими полями ввода
# При считывании данных из тестирующей системы Сириуса нужно использовать объект sirius_ans_obj
# со следующим интерфейсом.
# sirius_ans_obj.elements - количество "элементов" в ответе.
# sirius_ans_obj.fields_in_element(element=0) - возвращает количество полей ввода в элементе номер element, нумерация с нуля
# sirius_ans_obj.answer(element=0, field=0) - возвращает значение поля ввода номер field из элемента номер element, нумерация с нуля
########################################################################################

def get_answer():
    ans = []
    if SIRIUS:
        for i in range(sirius_ans_obj.elements):
            elem = sirius_ans_obj.answer(element=i)
            # Если ответ в Сириусе состоит из нескольких полей, то там может оказаться None. Необходимо это учесть.
            if elem is None:
                continue
            ans.append(elem.strip())
    elif POLYGON or SILVER:
        if POLYGON:
            fin = open(sys.argv[2], "r", encoding="utf8")
        elif SILVER:
            fin = sys.stdin
        for elem in fin:
            ans.append(elem.strip())
    return ans


ans = get_answer()
if len(ans) != 1:
    quit(PE, f"Ответ содержит {len(ans)} строк вместо одной", 0)


ans = ans[0].replace(" ", "").replace(",", "").replace(";", "")
ans = ans.upper().replace("А", "A").replace("Б", "B").replace("В", "B")
ans = ans.replace(chr(8722), "-") # неправильный минус
ans = ans.replace(chr(8212), "-") # неправильный минус
ans = ans.replace(chr(8210), "-") # неправильный минус
ans = ans.replace(chr(8211), "-") # неправильный минус

for c in ans:
    if c not in "AB2-":
        quit(PE, f"В ответе используется недопустимый символ \xAB{c}\xBB")


s = ""
for c in ans:
    if c == "2":
        s += s
    elif c == "-":
        s = s[:-1]
    else:
        s += c
        
TARGET = "ABAABABABAAB"

if s != TARGET:
    quit(WA, f"В результе исполнения алгоритма получилась неверная строка. Результом работы вашего алгоритма является строка \xAB{s}\xBB", )

if len(ans) == 8:
    quit(OK, "Это правильный и лучший ответ", 100)

if len(ans) < 8:
    quit(CF, "Ответ участника лучше ответа жюри", 0)

SCORES = {9: 55, 10: 35, 11: 20, 12: 10}

score = SCORES.get(len(ans), 10)

quit(WA, f"Это не самый лучший ответ, в вашем ответе {len(ans)} команд, а в лучшем ответе 8 команд", score)

