#!/usr/bin/python3
# -*- coding: utf-8 -*-
 
import sys
import os
import re
import json
 
# Определяем тип тестирующей системы
# В отладочных целях можно заменить эти переменные на константы True/False
POLYGON = ("polygon" in os.environ.get("APPDATA", "0").lower()) or ("codeforces" in os.environ.get("APPDATA", "0").lower())
EJUDGE = "EJUDGE" in os.environ
SILVER = "SILVERTESTS_VERSION" in os.environ
SIRIUS = not(POLYGON or EJUDGE or SILVER)
 
# Коды возврата для передачи в функцию quit
OK = 0
WA = 1
PT = 1
PE = 2
CF = 3
 
#эта часть нужна для отладки в Сириусе
right_ans = '{"solution":[1,11,13,16,17,19,2,21,22,24,25,27,28,3,30,31,33,34,36,37,39,42,43,45,47,48,49,5,51,53,56,57,58,59,6,61,62,63,64,7,8,9]}'
test_ans = right_ans
#test_ans = '{"solution":[2,3,4]}'
 
# Класс для работы с ответом участника в тестирующей системе Сириуса
class AnswerSMT():
    def __init__(self, userAnswer=None, score=0, maxScore=100):
        '''считывание ответа'''
        if userAnswer is None:
            self.userAnswer = json.loads("".join(sys.stdin.readlines()))['solution']
        else:
            self.userAnswer = json.loads(userAnswer)
        
        
        '''считаем количество элементов ввода и делаем список ответов по элементам ввода'''
        if type(self.userAnswer) is dict:
            self.elements = 1
            if type(self.userAnswer['solution']) is dict:
                self.userAnswer = [[self.userAnswer['solution']['message']]]
            elif type(self.userAnswer['solution']) is int:
                self.userAnswer = [[self.userAnswer['solution']]]
            else:
                self.userAnswer = [self.userAnswer['solution']]
        else: 
            self.elements = len(self.userAnswer)
            a = []
            for i in range(0, self.elements):
                if type(self.userAnswer[i]['solution']) is int:
                    a.append([self.userAnswer[i]['solution']])
                else:
                    a.append(self.userAnswer[i]['solution'])
            self.userAnswer = a
        
        '''считаем, сколько полей ввода для каждого элемента ввода'''
        self.userAnswerLength = []
        for i in range(0, self.elements):
            if type(self.userAnswer[i]) is list:
                self.userAnswerLength.append(len(self.userAnswer[i]))
            elif self.userAnswer[i] != '':
                self.userAnswerLength.append(1)
            else:
                self.userAnswerLength.append(0)
        
        self.comment = ''
        self.score = score
        self.maxScore = maxScore
        self.verdict = 'WA'
          
    def answer(self, element=0, field=0):
        '''Возвращает ответ участника из элмента ввода с номером element.
        Если в элементе ввода несколько полей ввода, то можно указать номер поля ввода'''
        if element >= self.elements:
            return None
        else:
            a = self.userAnswer[element]
        
        if a is None:
            return None
        if field >= len(a):
            return None
        else: 
            return None if a[field] is None else str(a[field])
    
    def fields_in_element(self, element=0):
        '''Возвращает информацию о количестве полей ввода в элементе ввода'''
        if len(self.userAnswerLength) <= element: 
            return 0
        else:
            return self.userAnswerLength[element]
    
    def print_answer(self):
        '''посмотреть всё содержимое для отладки'''
        print("user answer:")
        print(self.userAnswer)
        print("number of elements")
        print(self.elements)
        print('length of elements')
        print(self.userAnswerLength)
    
    def quit(self, comment=None, score=None, maxScore=None, verdict=None):
        if not comment is None:
            self.comment = comment
        
        if not score is None:
            self.score = score
        
        if not maxScore is None:
            self.maxScore = maxScore
            
        if not verdict is None:
            self.verdict = verdict
            
        print(json.dumps({"maxScore":self.maxScore,
                          "score":self.score,
                          "comment":self.comment,
                          "verdict":self.verdict}))
        sys.exit(0)
 
 
def quit(status, log="", score=0):
    if SIRIUS:
        if status in [OK, WA] and 0 < score < 100:
            status = PT
        comment = log.replace("\n", "\n\n") # Дублируем концы строк для разметки
        sirius_ans_obj.quit(verdict=status, comment=comment, score=score)
        return
    
    if POLYGON: # Нужно в Polygon, т.к. там Windows
        sys.stdout.reconfigure(encoding='utf-8')
        sys.stderr.reconfigure(encoding='utf-8')
 
    # Выводим набранные баллы
    if status in [OK, WA]:
        if POLYGON:
            sys.stderr.write("points " + str(score) + "\n")
            status = 7 # Код возврата полигона, сообщающий о наличии баллов
        elif EJUDGE or SILVER:
            sys.stdout.write(str(score) + "\n")
    
    # Выводим протокол проверки
    sys.stderr.write(log)
    
    # Возвращаем код возврата
    sys.exit(status)
 
 
def init():
    global OK, WA, PE, CF, PT
    global sirius_ans_obj
    if SIRIUS:
        PE = "PE"
        WA = "WA"
        OK = "OK"
        СF = "CF"
        PT = "PT"
        # При создании объекта можно в конструктор в целях отладки передать строку с JSON, тогда ответ будет считан с этого JSON, иначе из stdin
        sirius_ans_obj = AnswerSMT(test_ans)  #при заливке в систему -- удалить test_ans!!!!!!!!!!!!!!!!!!
 
 
init()
 
########################################################################################
# Код дальше можно править
# 
# Код этой функции надо исправить так, чтобы она возвращала ответ, полученный из JSON в Сириусе
# или полученный из файла в тестирующих системах Ejudge или Polygon
# Формат возвращаемого значения - произвольный, например, одна строка или список строк
# При необходимости можно прямо в этом коде делать quit(PE, ...)
#
# В тестирующей системе Сириуса:
# Задание состоит из "элементов" (разделов"), внутри раздела могут быть поля ввода.
# Например, задание вида "Дайте ответ для а) N = 10 б) N = 20, в) N = 30" - это три раздела, они будут визуально отделены.
# А задание вида "Напишите в ответе номера объектов, которые вы выбрали, добавляя поля по необходимости" - это один раздел с несколькими полями ввода
# При считывании данных из тестирующей системы Сириуса нужно использовать объект sirius_ans_obj
# со следующим интерфейсом.
# sirius_ans_obj.elements - количество "элементов" в ответе.
# sirius_ans_obj.fields_in_element(element=0) - возвращает количество полей ввода в элементе номер element, нумерация с нуля
# sirius_ans_obj.answer(element=0, field=0) - возвращает значение поля ввода номер field из элемента номер element, нумерация с нуля
########################################################################################
 
def get_answer():
    ans = []
    if SIRIUS:
        for i in range(sirius_ans_obj.elements):
            elem = sirius_ans_obj.answer(element=i)
            if elem is None:
                elem = ""
            ans.append(elem.strip())
    elif POLYGON or SILVER:
        if POLYGON:
            fin = open(sys.argv[2], "r", encoding="utf8")
        elif SILVER:
            fin = sys.stdin
        for elem in fin:
            elem = elem.strip()
            if elem:
                ans.append(elem)
    return ans 
 
ans = get_answer()

i = 0
while i < len(ans):
    ans[i] = ans[i].strip()
    for c in ans[i]:
        if c == " ":
            quit(PE, f"Строка {i+1} ответа содержит пробел. В ответе нужно записать 6 чисел, каждое число - в отдельной строке.")
        if not c.isdigit():
            quit(PE, f"Строка {i+1} ответа содержит символ \xAB{c}\xBB, не являющийся цифрой. В ответе должны быть только числа, каждое число - в отдельной строке.")
        
    i += 1


ANS  = [32, 0, 22, 18, 5, 9]

SCORES = [20, 15, 20, 15, 15, 15]


if len(ans) != len(ANS):
    quit(PE, f"В ответе должно быть {len(ANS)} чисел")

solved = 0
score = 0
for i in range(len(ans)):
    if int(ans[i]) == int(ANS[i]):
        solved += 1
        score += SCORES[i]

if solved == 6:
    quit(OK, "Все ответы верные", score=100)
else:
    quit(WA, f"Даны верные ответы на {solved} вопросов из 6\n", score=score)
