#include <array>
#include <set>

#include "testlib.h"

std::pair<bool, std::string> check_possible(std::multiset<int> h, int x, const std::array<int, 4> &choice) {
    for (int i = 0; i < 4; ++i) {
        if (h.find(choice[i]) == h.end()) {
            return { false, "choosen heights do not exist in array" };
        }
        h.erase(h.find(choice[i]));
    }
    auto [a, b, c, d] = choice;
    if (std::max(std::abs(a - b), std::abs(c - d)) != x) {
        return { false, "incorrect x" }; 
    }
    return { true, "" }; 
}

int main(int argc, char *argv[]) {
    registerTestlibCmd(argc, argv);
    int n = inf.readInt();
    std::multiset<int> h;
    for (int i = 0; i < n; ++i) {
        int x = inf.readInt();
        h.insert(x);
    }
    
    int jx = ans.readInt(0, 1'000'000'000, "x");
    std::array<int, 4> jans;
    for (int i = 0; i < 4; ++i) {
        jans[i] = ans.readInt(0, 1'000'000'000, "hi");
    }
    
    auto [jok, jerr] = check_possible(h, jx, jans);
    quitif(!jok, _fail, jerr.c_str());
    
    int px = ouf.readInt(0, 1'000'000'000, "x");
    std::array<int, 4> pans;
    for (int i = 0; i < 4; ++i) {
        pans[i] = ouf.readInt(0, 1'000'000'000, "hi");
    }
    
    auto [pok, perr] = check_possible(h, px, pans);
    quitif(!pok, _wa, perr.c_str());
    
    quitif(px < jx, _fail, "participant has a better answer");
    quitif(jx < px, _wa, "jury has a better answer");
    quitf(_ok, "ok");
}