#include <bits/stdc++.h>
#include "testlib.h"

using namespace std;

int n, m, r1, c1, r2, c2;

int dist(int r, int c)
{
    return min(abs(r - r1) + abs(c - c1), abs(r - r2) + abs(c - c2));
}

int main(int argc, char *argv[]) {
    registerTestlibCmd(argc, argv);

    n = inf.readInt();
    m = inf.readInt();
    r1 = inf.readInt();
    c1 = inf.readInt();
    r2 = inf.readInt();
    c2 = inf.readInt();

    vector<string> s = ouf.readLines(n);
    if (s.size() != n)
        quitf(_wa, "There must be exactly n=%d rows in output", n);
    
    for (int r = 1; r <= n; ++r)
        if (s[r - 1].size() != m)
            quitf(_wa, "Each row must have exactly m=%d signs", m);
    
    for (int r = 1; r <= n; ++r)
    {
        // string s = ouf.readLine("[<>v^S]{2,100}");
        // if (int(s.length()) != m)
        //     quitf(_wa, "Each row must be of length m");
        for (int c = 1; c <= m; ++c)
        {
            char dir = s[r - 1][c - 1];
            int curr_dist = dist(r, c);
            if (curr_dist == 0)
            {
                if (dir != 'S')
                    quitf(_wa, "Wrong sign in the room with staircase (must be 'S' char), row=%d, column=%d", r, c);
                else
                    continue;
            }
            if (dir == 'S')
                quitf(_wa, "Wrong sign 'S' in the room without staircase, row=%d, column=%d", r, c);
            int rn = r, cn = c;
            switch (dir)
            {
                case '<': cn--; break;
                case '>': cn++; break;
                case '^': rn--; break;
                case 'v': rn++; break;
                default: quitf(_wa, "Wrong sign '%c' in the room without staircase, row=%d, column=%d", dir, r, c);
            }
            if (rn < 1 || rn > n || cn < 1 || cn > m)
                quitf(_wa, "The sign '%c' in room points outside of building, row=%d, column=%d", dir, r, c);
            if (dist(rn, cn) >= curr_dist)
                quitf(_wa, "The sign '%c' in the room doesn't point toward the nearest staircase, row=%d, column=%d", dir, r, c);
        }
    }
    quitf(_ok, "Correct plan!");
}
